import { Link, useLocation } from 'react-router-dom'
import { Camera } from 'lucide-react'
import Footer from './Footer'
import './Layout.css'

const Layout = ({ children }) => {
  const location = useLocation()

  return (
    <>
      <header className="header">
        <div className="container">
          <div className="header-content">
            <Link to="/" className="logo">
              <Camera size={32} strokeWidth={2.5} className="logo-icon" />
              <span className="logo-text">PhotoStudio</span>
            </Link>
            <nav className="nav">
              <Link 
                to="/" 
                className={`nav-link ${location.pathname === '/' ? 'active' : ''}`}
              >
                Мои съёмки
              </Link>
              <Link 
                to="/book" 
                className={`nav-link ${location.pathname === '/book' ? 'active' : ''}`}
              >
                Записаться
              </Link>
            </nav>
          </div>
        </div>
      </header>
      <main>{children}</main>
      <Footer />
    </>
  )
}

export default Layout

